package MSocials;
use strict;

use MCoreTools;

use vars qw(
  %Socials
);

sub load {
  mudlog "Loading socials...";
  %Socials = %{do(rfile('config/socials.pl'))};
}

sub all {
  return keys %Socials;
}

sub cmatch {
  my ($class, $prefix) = @_;
  
  (my $res) = grep /^\Q$prefix/, keys %Socials;
  return "SOC:$res" if $res;
  return;
}

sub do {
  my ($class, $self, $name, $args) = @_;
  
  my $soc = $Socials{$name} or croak "bad social name: $name";

  my ($adj, $target);
  if ($args =~ s/^(@{[join '|', @{$soc->{advs}}]})(\s+|$)//) {
    $adj = $1;
  } elsif (my ($first, $space) = $args =~ /^(.*?)(\s+|$)/) {
    ($adj) = grep /^\Q$first/, @{$soc->{advs}}
      if length $first;
    $args =~ s/^$first$space// if $adj;
  }
  
  $args =~ s/^(at|to)\s+//;
  $target = $self->object_find($args) if $args;
  
  my $mstr = $soc->{msg};
  $mstr =~ s/\[(.*?)ADJ(.*?)\]/$adj ? "$1$adj$2" : ''/e;
  $mstr =~ s/\[(.*?<target.*?)\]/$target ? $1 : ''/e;
  
  if (!$target and $mstr =~ /<target/) {
    die "CFAIL:You must specify a target to $name!";
  }

  $self->nact($mstr, ($target ? (target => $target) : ()));
}

sub info_msg {
  my ($class, $name) = @_;
  my $soc = $Socials{$name} or return;
  return $soc->{msg};
}

sub info_advs {
  my ($class, $name) = @_;
  my $soc = $Socials{$name} or return;
  return @{ $soc->{advs} };
}

1;